#! /bin/bash

if [ -n "$1" ] && [ -n "$2" ]
then
    if [ -n "$3" ]
    then
        target_fs=$3
    else
        target_fs=${TARGETFS}
    fi
    
    cat $1 | grep '\[0x' | while read stack_line
    do
        echo $stack_line

        lib_name=`echo $stack_line | sed 's/\(.*[(]\).*/\1/' | sed 's/\(.*[\[]\).*/\1/' | sed 's/[(\[]//g'`
        code_addr=`echo $stack_line | sed -n 's:.*\[\(.*\)\].*:\1:p'`

        cat $2 | grep $lib_name | grep 'r-xp' | while read map_line
        do
            lib_addr=`echo $map_line | sed 's/\([0-f]\+\).*/0x\1/'`
            code_offset=$(($code_addr-$lib_addr))
            code_offset=`printf "0x%x\n" $code_offset`
            func_name=`addr2line -Cif -e ${target_fs}/${lib_name} ${code_offset} | sed -n 1p`
            line_num=`addr2line -Cif -e ${target_fs}/${lib_name} ${code_offset} | sed -n 2p`
            echo "    $func_name : $line_num"
        done
    done
else
    echo "Usage: $0 stack-dump-file map-file [target-fs]"
fi
